<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function addTransaction($data,$sale)
    { 
        
        $data['sale_id'] = $sale;
        if ($this->db->insert('transaction', $data))
        {
            $transaction_id = $this->db->insert_id();
            return true;
        }
        return FALSE;
    }
    
    public function addExpenseTransaction($expense_data)
    { 
        
        
        if ($this->db->insert('expenses', $expense_data))
        {
            $transaction_id = $this->db->insert_id();
            return true;
        }
        return FALSE;
    }
    
    
    public function addTransa($data)
    { //print_r($data);die();
        $edata= array(
           'date' => $data['date'],
                'reference' => $this->site->getReference('ex'),
                'amount' => $data['amount'],
                'vat' => $data['vat'],
                'created_by' => $this->session->userdata('user_id'),
                'note' =>$data['note'],
                'category_id' => $data['category'],
                'warehouse_id' =>$data['warehouse_id']
            );
           //print_r($edata);die(); 
        if ($this->db->insert('transaction', $data))
        {
            $transaction_id = $this->db->insert_id();
            if ($this->db->insert('expenses', $edata)) 
            {
                if ($this->site->getReference('ex') == $edata['reference']) 
                {
                $this->site->updateReference('ex');
                }
            }
            return true;
        }
        return FALSE;
    }
    
    public function addTransaction_Purchase($data,$sale)
    { 
        $data['purchase_id'] = $sale;
        if ($this->db->insert('transaction', $data))
        {
            $transaction_id = $this->db->insert_id();
            return true;
        }
        return FALSE;
    }
    
    public function updateSale($id,$data)
    { 
        if ($this->db->update('transaction', $data, array('sale_id' => $id)))
        {
            $transaction_id = $this->db->insert_id();
            return true;
        }
        return FALSE;
    }
    
    public function updatePurchase($id,$data)
    { 
        if ($this->db->update('transaction', $data, array('purchase_id' => $id)))
        {
            $transaction_id = $this->db->insert_id();
            return true;
        }
        return FALSE;
    }
    
    public function getAllTransaction()
    {
        $q = $this->db->get('transaction');
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function getAllTransactions($warehouse,$start_date, $end_date)
    {
         $this->db
                ->select('*')
                 ->from('transaction');
         if ($warehouse) {
                $this->db->where('warehouse_id', $warehouse);
            }
             if ($start_date) {
                $this->db->where($this->db->dbprefix('transaction').'.date BETWEEN "' . $start_date . '" and "' . $end_date . '"');
            }
          $q = $this->db->get();
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllTransactionByID($id)
    {
        $q = $this->db->get_where('transaction', array('id' => $id), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }
    
    
    public function deleteTransaction($id)
    {
        if ($this->db->delete('transaction', array('id' => $id))) 
        {
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
    
    public function addAccount($data)
    {
        if ($this->db->insert('accounts', $data)) 
        {
            $account_id = $this->db->insert_id();

            return true;
        }
        return false;

    }
    public function getAllAccount()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                
                $data[] = $row;
            
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllAccounts()
    {
        $q = $this->db->get('accounts');
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                if(($row->account_category ==2)||($row->account_category==6))
                {
                    $data[] = $row;
                }
            }
            return $data;
        }
        return FALSE;
    }
    
    public function getAllCateType() 
    {
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                if(($row->belongs_to ==1)||($row->belongs_to==3))
                {
                    $data[] = $row;
                }
            }
            return $data;
        }
        return FALSE;
    }
    public function getCateType() 
    {
        $q = $this->db->get("accounts");
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row) 
            {
                if(($row->belongs_to ==2)||($row->belongs_to==3))
                {
                    $data[] = $row;
                }
            }
            return $data;
        }
        return FALSE;
    }
    
    public function updateAccount($id,$data)
    {
        if ($this->db->update('accounts', $data, array('id' => $id))) 
        {
            $account_ids = $this->db->insert_id();

            return true;
        }
        return false;

    }
    
    public function getAllAccountByID($id) 
    {
        $q = $this->db->get_where('accounts', array('id' => $id), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getAllAccountByType($types) 
    {
        $q = $this->db->get_where('accounts', array('type' => $types), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        
        return FALSE;
    }
    
    public function deleteAccount($id)
    {
        if ($this->db->delete('accounts', array('id' => $id))) {
            /*$this->db->delete('transaction', array('product_id' => $id));
            $this->db->delete('product_variants', array('product_id' => $id));
            $this->db->delete('product_photos', array('product_id' => $id));
            $this->db->delete('product_prices', array('product_id' => $id));*/
            return true;
        }
        return FALSE;
    }
    
    
    public function addStatement($start_date,$end_date,$Account) 
    { 
        $this->db->where("date <=", $end_date);
        $this->db->where("date >=", $start_date);
        $this->db->where("account", $Account);
        $q = $this->db->get('transaction');
        if ($q->num_rows() > 0) 
        {
           foreach (($q->result()) as $row) 
           {
                $data[] = $row;
           }
           return $data;
        }
        return array();
    }
 public function getTrandByName($name)
    {
        $q = $this->db->get_where('type', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function addType($data)
    {
        if ($this->db->insert("type", $data)) 
        {
            return true;
        }
        return false;
    }

    public function addTypes($data)
    {
        if ($this->db->insert_batch('type', $data)) 
        {
            return true;
        }
        return false;
    }

    public function updateType($id, $data = array())
    {
        if ($this->db->update("type", $data, array('id' => $id))) 
        {
            return true;
        }
        return false;
    }

    public function typeHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('type' => $type_id), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteType($id)
    {
        if ($this->db->delete("type", array('id' => $id))) 
        {
            return true;
        }
        return FALSE;
    }
    
    public function getTransactionCategoryByID($id)
    {
        $q = $this->db->get_where("transaction_categories", array('id' => $id), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function getTransactionCategoryByCode($code)
    {
        $q = $this->db->get_where("transaction_categories", array('code' => $code), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function addTransactionCategory($data)
    {
        if ($this->db->insert("transaction_categories", $data)) 
        {
            return true;
        }
        return false;
    }

    public function addTransactionCategories($data)
    {
        if ($this->db->insert_batch("transaction_categories", $data)) 
        {
            return true;
        }
        return false;
    }

    public function updateTransactionCategory($id, $data = array())
    {
        if ($this->db->update("transaction_categories", $data, array('id' => $id))) 
        {
            return true;
        }
        return false;
    }

    public function hasTransactionCategoryRecord($id)
    {
        $this->db->where('id', $id);
        return $this->db->count_all_results('transaction');
    }

    public function deleteTransactionCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
        {
            return true;
        }
        return FALSE;
    }
    public function deleteCategory($id)
    {
        if ($this->db->delete("transaction_categories", array('id' => $id))) 
        {
            return true;
        }
        return FALSE;
    }
    public function getAccountCategoryByName($name)
    {
        $q = $this->db->get_where('account_category', array('name' => $name), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function addAccountCategory($data)
    {
        if ($this->db->insert("account_category", $data)) 
        {
            return true;
        }
        return false;
    }

    public function addAccountCategories($data)
    {
        if ($this->db->insert_batch('type', $data)) 
        {
            return true;
        }
        return false;
    }

    public function updateAccountCategory($id, $data = array())
    {
        if ($this->db->update("account_category", $data, array('id' => $id))) 
        {
            return true;
        }
        return false;
    }

    public function AccountCategoryHasTransaction($brand_id)
    {
        $q = $this->db->get_where('transaction', array('account_category' => $account_category_id), 1);
        if ($q->num_rows() > 0) 
        {
            return $q->row();
        }
        return FALSE;
    }

    public function deleteAccountCategory($id)
    {
        if ($this->db->delete("account_category", array('id' => $id))) 
        {
            return true;
        }
        return FALSE;
    }
  public function getAllAccountCategory()
    {
        $q = $this->db->get('account_category');
        
        if ($q->num_rows() > 0) 
        {
            foreach (($q->result()) as $row)
            {
                $data[] = $row;
            } 
            return $data;
        }
        return FALSE;
    }
     public function getCompanyByID() {
      $q = $this->db->get_where('companies', array('group_name' => 'customer'));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function getCompaniesByID() {
      $q = $this->db->get_where('companies', array('group_name' => 'supplier'));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function TotalSale($cust) {
      $q = $this->db->get_where('sales', array('`customer_id' => $cust));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    public function addCustomer($data,$cdata)
    {//print_r($data);die();
       if ($this->db->insert('deposits', $data) && 
            $this->db->update('companies', $cdata, array('id' => $data['company_id']))) 
            {
                
               $this->db
                        ->select('*')
                        ->from('sales')
                        ->where('customer_id',$data['company_id'])
                        ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE)
                        ->order_by("id", "asc"); 
                        $sale = $this->db->get();
                        
                foreach($sale->result() as $row)
                {
                    
                    if($data['amount'] !=0)
                    {
                            $paid           = $row->paid ? $row->paid:'0';
                            $grandtotal     = $row->grand_total;
                            
                        if($grandtotal == $data['amount'])
                        {
                            $balance                    = $grandtotal - $paid;
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $transt =array
                            (
                                'type'                  => 'income',
                                'account'               => '5',
                                'category'              => '8',
                                'date'                  => $data['date'],
                                'amount'                => $balance,
                                'note'                  => '',
                                'description'           => 'Sale',
                                'acc_type'              => '18',
                                'deposit_withdrawal'    => 'deposit',
                                'sale_id'               => $row->id,
                                'warehouse_id'          => $warehouse_id,
                                 'customer_id'           => $data['company_id'],
                                   'payment_method'          => $data['payment_method']
                             );
                            //print_r($transt);
                            $paymentt = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        =>  $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'Received',
                                 'sale_id'      => $row->id
                            );//print_r($payment);die();
                            $dat = array
                            (
                                'paid'          =>$paid,
                                'sale_status'   => $sale_status,
                                'payment_status'=> $payment_status
                            );
                            if($this->db->update('sales', $dat, array('id' => $row->id)) &&  $this->db->insert('transaction', $transt) &&$this->db->insert('payments', $paymentt) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] > $grandtotal)
                        {
                            //echo"3";die();
                    
                
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $balance                    = $grandtotal - $paid;  
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $dar =array
                            (
                                 'paid'             => $paid,
                                 'sale_status'      => $sale_status,
                                 'payment_status'   => $payment_status
                            );  
                            $transr =array
                            (
                                'type'              => 'income',
                                'account'           => '5',
                                'category'          => '8',
                                'date'              => $data['date'],
                                'amount'            => $balance,
                                'note'              => '',
                                'description'       => 'Sale',
                                'acc_type'          =>  '18',
                                'deposit_withdrawal'=> 'deposit',
                                'sale_id'           => $row->id,
                                'warehouse_id'      => $warehouse_id,
                                 'customer_id'           => $data['company_id'],
                                   'payment_method'          => $data['payment_method']
                            );
                           // print_r($transr);
                            $paymentr = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        => $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'Received',
                                 'sale_id'      => $row->id
                       
                            );
                          
                            if($this->db->update('sales', $dar, array('id' => $row->id)) &&  $this->db->insert('transaction', $transr) && $this->db->insert('payments', $paymentr) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] < $grandtotal)
                        {
                            $balance = $grandtotal - $paid;
                           
                            if($data['amount'] == $balance)
                            {
                                $payment_status         = 'paid';
                                $sale_status            = 'completed';
                                $paid                   = $paid + $data['amount'];
                                $data['amount']         =  0;
                                $payment['reference_no']= $this->site->getReference('pay');
                                $warehouse_id           = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $das =array
                                (
                                     'paid'             => $paid,
                                     'sale_status'      => $sale_status,
                                     'payment_status'   => 'paid'
                                );
                                $transs =array
                                (
                                    'type'              => 'income',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                       'payment_method'          => $data['payment_method']
                                );
                                $payments = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                                );
                                if($this->db->update('sales', $das, array('id' => $row->id)) &&  $this->db->insert('transaction', $transs) && $this->db->insert('payments', $payments) )
                                    {
                                  
                                        //print_r($trans);die();
                                        $this->site->updateReference('pay');
                                        //return true;
                                    }
                            } 
                            elseif($data['amount'] < $balance)
                            {
                                $payment_status             = 'paid';
                                $sale_status                = 'completed';
                                $paid                       = $paid + $data['amount'];
                                $data['amount']             =  0;
                                $payment['reference_no']    = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $daq =array
                                (
                                 'paid'             => $paid,
                                 'sale_status'      => $sale_status,
                                 'payment_status'   => 'due'
                                );
                                $transq =array
                                (
                                    'type'              => 'income',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                      'payment_method'          => $data['payment_method']
                                );
                                //print_r($transr);
                                $paymentq = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                       
                                );  
                                if($this->db->update('sales', $daq, array('id' => $row->id)) &&  $this->db->insert('transaction', $transq) && $this->db->insert('payments', $paymentq) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                            elseif($data['amount'] > $balance)
                            {
                                $payment_status = 'paid';
                                $sale_status = 'completed';
                                $paid = $paid +  $balance;
                                $data['amount']= $data['amount'] -  $balance ;
                                $payment['reference_no'] = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $daf =array
                                (
                                    'paid'=>$paid,
                                    'sale_status'=> $sale_status,
                                    'payment_status'=> 'paid'
                                );
                                $transf =array
                                (
                                    'type'              =>'income',
                                    'account'           =>'5',
                                    'category'          =>'8',
                                    'date'              =>$data['date'],
                                    'amount'            =>$paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          =>  '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      =>$warehouse_id,
                                     'customer_id'           => $data['company_id'],
                                       'payment_method'          => $data['payment_method']
                                );
                               // print_r($transr);
                                $paymentf = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                       
                                );

                                if($this->db->update('sales', $daf, array('id' => $row->id)) &&  $this->db->insert('transaction', $transf) && $this->db->insert('payments', $paymentf) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                 
                        }
                         $cfi   =  $data['amount'];
                    $cdat   = array('deposit_amount'=>$cfi);
                    $this->db->update('companies', $cdat, array('id' => $data['company_id']));
                    }
                       
                }//die();
            
            return true;
        }
        return false;
    }
     public function addSupplier($data,$cdata)
    {//print_r($cdata);die();
       if ($this->db->insert('deposits', $data) && 
            $this->db->update('companies', $cdata, array('id' => $data['company_id']))) 
            {
               $this->db->order_by("id", "asc"); 
               $this->db
                        ->select('*')
                        ->from('purchases')
                        ->where('supplier_id',$data['company_id'])
                        ->where("(payment_status='pending' OR payment_status='due')", NULL, FALSE);
                        $sale = $this->db->get();
                        //print_r($sale->result());die();
                foreach($sale->result() as $row)
                {
                    if($data['amount'] !=0)
                    {
                        $paid           =$row->paid;
                        $grandtotal     = $row->grand_total;//print_r($payment_status);
                        if($grandtotal == $data['amount'])
                        {//echo"2";die();
                            $balance                    = $grandtotal - $paid;
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $transfa =array
                            (
                                'type'                  => 'expense',
                                'account'               => '5',
                                'category'              => '8',
                                'date'                  => $data['date'],
                                'amount'                => $balance,
                                'note'                  => '',
                                'description'           => 'Sale',
                                'acc_type'              => '18',
                                'deposit_withdrawal'    => 'deposit',
                                'sale_id'               => $row->id,
                                'warehouse_id'          => $warehouse_id,
                                 'payment_method'          => $data['payment_method']
                             );
                            $paymentfa = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        =>  $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'Received',
                                 'sale_id'      => $row->id
                            );//print_r($payment);die();
                            $dafa = array
                            (
                                'paid'          =>$paid,
                                'status'    => $sale_status,
                                'payment_status'=> $payment_status
                            );
                            if($this->db->update('purchases', $dafa, array('id' => $row->id)) &&  $this->db->insert('transaction', $transfa) &&$this->db->insert('payments', $paymentfa) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] > $grandtotal)
                        {//echo"3";die();
                            $payment_status             = 'paid';
                            $sale_status                = 'completed';
                            $balance                    = $grandtotal - $paid;
                            $paid                       = $paid +  $balance;
                            $data['amount']             = $data['amount'] - $balance;
                            $payment['reference_no']    = $this->site->getReference('pay');
                            $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                            $daw =array
                            (
                                 'paid'             => $paid,
                                 'status'       => $sale_status,
                                 'payment_status'   => $payment_status
                            );
                            $transw =array
                            (
                                'type'              => 'expense',
                                'account'           => '5',
                                'category'          => '8',
                                'date'              => $data['date'],
                                'amount'            => $balance,
                                'note'              => '',
                                'description'       => 'Sale',
                                'acc_type'          =>  '18',
                                'deposit_withdrawal'=> 'deposit',
                                'sale_id'           => $row->id,
                                'warehouse_id'      => $warehouse_id,
                                 'payment_method'          => $data['payment_method']
                            );
                            $paymentw = array
                            (
                                'date'          => $data['date'],
                                'reference_no'  => $payment['reference_no'],
                                'amount'        => $balance,
                                'paid_by'       => $data['paid_by'],
                                'cheque_no'     => '',
                                'cc_no'         => '',
                                'cc_holder'     => '',
                                'cc_month'      => '',
                                'cc_year'       => '',
                                'cc_type'       => '',
                                'created_by'    => $data['created_by'],
                                'note'          => '',
                                'type'          => 'Received',
                                 'sale_id'      => $row->id
                       
                            );
                          
                            if($this->db->update('purchases', $daw, array('id' => $row->id)) &&  $this->db->insert('transaction', $transw) && $this->db->insert('payments', $paymentw) )
                            {
                          
                                //print_r($trans);die();
                                $this->site->updateReference('pay');
                                //return true;
                            }
                        } 
                        elseif($data['amount'] < $grandtotal)
                        {//echo"4";die();
                            $balance = $grandtotal - $paid;
                            if($data['amount'] == $balance)
                            {
                                $payment_status         = 'paid';
                                $sale_status            = 'completed';
                                $paid                   = $paid + $data['amount'];
                                $data['amount']         =  0;
                                $payment['reference_no']= $this->site->getReference('pay');
                                $warehouse_id           = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $dae =array
                                (
                                     'paid'             => $paid,
                                     'status'       => $sale_status,
                                     'payment_status'   => 'paid'
                                );
                                $transe =array
                                (
                                    'type'              => 'expense',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'payment_method'          => $data['payment_method']
                                );
                                $paymente = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                                );
                                if($this->db->update('purchases', $dae, array('id' => $row->id)) &&  $this->db->insert('transaction', $transe) && $this->db->insert('payments', $paymente) )
                                    {
                                  
                                        //print_r($trans);die();
                                        $this->site->updateReference('pay');
                                        //return true;
                                    }
                            } 
                            elseif($data['amount'] < $balance)
                            {
                                $payment_status             = 'paid';
                                $sale_status                = 'Received';
                                $paid                       = $paid + $data['amount'];
                                $data['amount']             =  0;
                                $payment['reference_no']    = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('purchases',array('id'=>$row->id))->row()->warehouse_id;
                                $dag =array
                                (
                                 'paid'             => $paid,
                                 'status'       => $sale_status,
                                 'payment_status'   => 'due'
                                );
                                $transg =array
                                (
                                    'type'              => 'expense',
                                    'account'           => '5',
                                    'category'          => '8',
                                    'date'              => $data['date'],
                                    'amount'            => $paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          => '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      => $warehouse_id,
                                     'payment_method'          => $data['payment_method']
                                );
                                $paymentg = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                       
                                );  //echo"kk";die();
                                if($this->db->update('purchases', $dag, array('id' => $row->id)) &&  $this->db->insert('transaction', $transg) && $this->db->insert('payments', $paymentg) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                            elseif($data['amount'] > $balance)
                            {
                                $payment_status = 'paid';
                                $sale_status = 'completed';
                                $paid = $paid +  $balance;
                                $data['amount']= $data['amount'] -  $balance ;
                                $payment['reference_no'] = $this->site->getReference('pay');
                                $warehouse_id               = $this->db->get_where('sales',array('id'=>$row->id))->row()->warehouse_id;
                                $dav =array
                                (
                                    'paid'=>$paid,
                                    'status'=> $sale_status,
                                    'payment_status'=> 'paid'
                                );
                                $transv =array
                                (
                                    'type'              =>'expense',
                                    'account'           =>'5',
                                    'category'          =>'8',
                                    'date'              =>$data['date'],
                                    'amount'            =>$paid,
                                    'note'              => '',
                                    'description'       => 'Sale',
                                    'acc_type'          =>  '18',
                                    'deposit_withdrawal'=> 'deposit',
                                    'sale_id'           => $row->id,
                                    'warehouse_id'      =>$warehouse_id,
                                     'payment_method'          => $data['payment_method']
                                );
                                $paymentv = array
                                (
                                    'date'          => $data['date'],
                                    'reference_no'  => $payment['reference_no'],
                                    'amount'        => $paid,
                                    'paid_by'       => $data['paid_by'],
                                    'cheque_no'     => '',
                                    'cc_no'         => '',
                                    'cc_holder'     => '',
                                    'cc_month'      => '',
                                    'cc_year'       => '',
                                    'cc_type'       => '',
                                    'created_by'    => $data['created_by'],
                                    'note'          => '',
                                    'type'          => 'Received',
                                    'sale_id'       => $row->id
                       
                                );
                                if($this->db->update('purchases', $dav, array('id' => $row->id)) &&  $this->db->insert('transaction', $transv) && $this->db->insert('payments', $paymentv) )
                                {
                                  
                                    //print_r($trans);die();
                                    $this->site->updateReference('pay');
                                    //return true;
                                }
                            } 
                   
                        }
                         $cfi   =  $data['amount'];
                    $cdat   = array('cf1'=>$cfi);
                    $this->db->update('companies', $cdat, array('id' => $data['company_id']));
                    }
                       
                }//die();
            
            return true;
        }
        return false;
    }
  

 public function check_totsaleamount($cus_id)
    {
             $this->db
                ->select('SUM(grand_total) as s_grand_total')
                 ->from('sales')
                 
                // ->where('category_id', $cat_id)
                 ->where('customer_id', $cus_id);

        $q = $this->db->get();
        if ($q->num_rows() > 0)
        {
           foreach (($q->result()) as $row)
            {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }




}
