/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.StringCharacterIterator;
import java.util.LinkedList;
import java.util.logging.Level;
import qz.Base64;
import qz.ByteArrayBuilder;
import qz.LogIt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteUtilities {
    protected static final char[] HEXES_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String HEXES = "0123456789ABCDEF";

    public static byte[] hexStringToByteArray(String s) throws NumberFormatException {
        byte[] data = new byte[]{};
        if (s != null && s.length() > 0) {
            if (s.length() > 2) {
                String[] split;
                if (s.length() >= 3 && s.contains("x")) {
                    s = s.startsWith("x") ? s.substring(1) : s;
                    s = s.endsWith("x") ? s.substring(0, s.length() - 1) : s;
                    split = s.split("x");
                } else {
                    split = s.split("(?<=\\G..)");
                }
                data = new byte[split.length];
                for (int i = 0; i < split.length; ++i) {
                    Integer signedByte = Integer.parseInt(split[i], 16);
                    data[i] = (byte)(signedByte & 0xFF);
                }
            } else if (s.length() == 2) {
                data = new byte[]{Byte.parseByte(s)};
            }
        }
        return data;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEXES_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEXES_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static int[] indicesOfSublist(byte[] array, byte[] sublist) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        if (array == null || sublist == null || array.length == 0 || sublist.length == 0 || sublist.length > array.length) {
            return new int[0];
        }
        block0: for (int i = 0; i < array.length - sublist.length + 1; ++i) {
            for (int j = 0; j < sublist.length; ++j) {
                if (array[i + j] != sublist[j]) continue block0;
            }
            indexes.add(i);
        }
        int[] int_array = new int[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            int_array[i] = (Integer)indexes.get(i);
        }
        return int_array;
    }

    public static LinkedList<ByteArrayBuilder> splitByteArray(byte[] src, byte[] pattern, int count) throws NullPointerException, IndexOutOfBoundsException, ArrayStoreException {
        LinkedList<ByteArrayBuilder> byteArrayList = new LinkedList<ByteArrayBuilder>();
        int[] split = ByteUtilities.indicesOfSublist(src, pattern);
        count = count < 1 ? 1 : count;
        int _count = 1;
        int prev = 0;
        ByteArrayBuilder b = new ByteArrayBuilder();
        for (int i : split) {
            byte[] temp = new byte[i - prev + pattern.length];
            System.arraycopy(src, prev, temp, 0, temp.length);
            b.append(temp);
            if (_count < count) {
                ++_count;
            } else {
                byteArrayList.add(b);
                b = new ByteArrayBuilder();
                _count = 1;
            }
            prev = i + pattern.length;
        }
        if (!byteArrayList.contains(b)) {
            byteArrayList.add(b);
        }
        return byteArrayList;
    }

    public static byte[] intArrayToByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    public static int[] binaryArrayToIntArray(boolean[] black) {
        int[] hex = new int[black.length / 8];
        for (int i = 0; i < hex.length; ++i) {
            for (int k = 0; k < 8; ++k) {
                int n = i;
                hex[n] = hex[n] + ((black[8 * i + k] ? 1 : 0) << 7 - k);
            }
        }
        return hex;
    }

    public static String getHexString(int[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (int i : raw) {
            hex.append(HEXES.charAt((i & 0xF0) >> 4)).append(HEXES.charAt(i & 0xF));
        }
        return hex.toString();
    }

    public static boolean isBlank(Object o) {
        if (o instanceof byte[]) {
            return ((byte[])o).length < 1;
        }
        if (o instanceof String) {
            return (String)o == null || ((String)o).equals("");
        }
        LogIt.log(Level.WARNING, "Uchecked blank comparison.");
        return o == null;
    }

    public static boolean isBase64Image(String path) {
        return path.startsWith("data:image/") && path.contains(";base64,");
    }

    public static boolean isBase64PDF(String path) {
        return path.startsWith("data:application/pdf;base64,");
    }

    public static byte[] readBinaryFile(String file) throws IOException, MalformedURLException {
        int len;
        if (ByteUtilities.isBase64PDF(file)) {
            return Base64.decode(file.split(",")[1]);
        }
        URLConnection con = new URL(file).openConnection();
        InputStream in = con.getInputStream();
        int size = con.getContentLength();
        ByteArrayOutputStream out = size != -1 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream(20480);
        byte[] buffer = new byte[512];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    public String escape(String unescaped) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(unescaped);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '/') {
                result.append("\\/");
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

