<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Clearance_charge extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('clearance_charge', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('clearance_charge_model');
        $this->data['pb'] = array(
            'cash' => lang('cash'),
            'CC' => lang('CC'),
            'Cheque' => lang('Cheque'),
            'paypal_pro' => lang('paypal_pro'),
            'stripe' => lang('stripe'),
            'gift_card' => lang('gift_card'),
            'deposit' => lang('deposit'),
            'authorize' => lang('authorize'),
            );

    }

     

 function index()
    {
        $this->sma->checkPermissions();
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
       // $this->data['monthly_sales'] = $this->reports_model->getChartData();
       // $this->data['stock'] = $this->reports_model->getStockValue();
          $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('clearance_charge')));
        $meta = array('page_title' => lang('clearance_charge'), 'bc' => $bc);
        $this->page_construct('clearance_charge/index', $meta, $this->data);

    }
 
  public function getClearance($warehouse_id = null)
    {
     
        $this->sma->checkPermissions('index');

        $clearance_charge = $this->input->get('clearance_charge') ? $this->input->get('clearance_charge') : NULL;
         $warehouse_id = $this->input->get('warehouse_id') ? $this->input->get('warehouse_id') : NULL;
         
        $detail_link = anchor('admin/purchases/view/$1', '<i class="fa fa-file-text-o"></i> ' . lang('purchase_details'));
       
        
        $delete_link = "<a href='#' class='po' title='<b>" . $this->lang->line("delete_purchase") . "</b>' data-content=\"<p>"
        . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('purchases/delete/$1') . "'>"
        . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i> "
        . lang('delete_purchase') . "</a>";
        $action = '<div class="text-center"><div class="btn-group text-left">'
        . '<button type="button" class="btn btn-default btn-xs btn-primary dropdown-toggle" data-toggle="dropdown">'
        . lang('actions') . ' <span class="caret"></span></button>
        <ul class="dropdown-menu pull-right" role="menu">
            <li>' . $detail_link . '</li>
           
        </ul>
    </div></div>';
        //$action = '<div class="text-center">' . $detail_link . ' ' . $edit_link . ' ' . $email_link . ' ' . $delete_link . '</div>';

        $this->load->library('datatables');
        
            $this->datatables
                ->select("id, DATE_FORMAT(date, '%Y-%m-%d %T') as date, reference_no,airway_bill_number,clearance_charge,supplier, status, grand_total,(IF(COALESCE(airway_bill_number,'')='',product_tax,'0')), paid, (grand_total-paid) as balance, payment_status, attachment")
               ->from('purchases');
			   // ->where('clearance_charge != ""',NULL);
            
        // $this->datatables->where('status !=', 'returned');
        if (!$this->Customer && !$this->Supplier && !$this->Owner && !$this->Admin && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        } elseif ($this->Supplier) {
            $this->datatables->where('supplier_id', $this->session->userdata('user_id'));
        }
        $this->datatables->add_column("Actions", $action, "id");
        echo $this->datatables->generate();
    }
   

  
}
