<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        if (!$this->loggedIn) 
		{
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        $this->lang->admin_load('transaction', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('transaction_model');
		$this->load->admin_model('purchases_model');
		$this->load->admin_model('companies_model');
		$this->load->model('site');
        $this->digital_upload_path = 'files/';
        $this->upload_path = 'assets/uploads/';
        $this->thumbs_path = 'assets/uploads/thumbs/';
        $this->image_types = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif|txt';
        $this->allowed_file_size = '1024';
        $this->popup_attributes = array('width' => '900', 'height' => '600', 'window_name' => 'sma_popup', 'menubar' => 'yes', 'scrollbars' => 'yes', 'status' => 'no', 'resizable' => 'yes', 'screenx' => '0', 'screeny' => '0');
    }
	
/***************************** transaction *********************/
	function add()
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$this->data['account'] = $this->transaction_model->getAllAccounts();
		$this->data['accounts'] = $this->transaction_model->getAllAccounts();
		$this->data['categories'] = $this->transaction_model->getAllCateType();
		$this->data['categor'] = $this->transaction_model->getCateType();
		 $this->data['warehouses'] = $this->site->getAllWarehouses();
		 $this->data['customerlist'] = $this->transaction_model->getCompanyByID();
		 	 $this->data['suppllist'] = $this->transaction_model->getCompaniesByID();
        $this->data['transaction'] = $this->transaction_model->getAllTransaction();  
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/add'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
        $meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
        $this->page_construct('transaction/add', $meta, $this->data);
		
    }
		function save()
    {
        //print_r($this->input->get());die();
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$start_price = 0;
		
		//$this->form_validation->set_rules('amount', 'amount', "trim|required|greater_than[$start_price]");
		
		//$this->form_validation->set_rules('Account', 'Account', 'required|numeric|max_length[20]');
		$this->form_validation->set_rules('type', 'type', 'required|trim');
		//$this->form_validation->set_rules('customer', 'customer', 'required|trim');
		//	$this->form_validation->set_rules('supplier', 'supplier', 'required|trim');
		$test = $this->input->post('test');
		if($test == 'customer_deposit'){
		    $this->form_validation->set_rules('customer', 'customer', 'required|trim');
		   } elseif($test == 'supplier_deposit'){
		       
		       $this->form_validation->set_rules('supplier', 'supplier', 'required|trim');
		   }
		$warehouse_id = $this->input->post('warehouse');
		if ($this->form_validation->run() == true) 
		{
			if($test == 'income')
			{
				$inc = $this->input->post('category');
				$types = $this->db->get_where('accounts',array('id'=> $inc))->row()->type;
				$data = array(
								'type' =>$this->input->post('type'),
								'warehouse_id' => $warehouse_id,
								'date' =>$this->sma->fld(trim($this->input->post('datee'))),
								'Account' => $this->input->post('Account') ? $this->input->post('Account') : 0,
								'category' => $this->input->post('category'),
								'amount' => $this->input->post('amounts'),
								'description' => $this->sma->clear_tags($this->input->post('description')),
								'deposit_withdrawal' => $this->input->post('deposit/withdrawal'),
								'note' => $this->sma->clear_tags($this->input->post('notee')),
								 'acc_type' => $types,
				                'cash_type'=>'2',
				                 'vat'=>'0',
				
							);
			}
			if($test == 'customer_deposit')
			{ 

			$cust=$this->input->post('customer');
        	$company = $this->companies_model->getCompanyByID($cust);
       			 $date = $this->sma->fld(trim($this->input->post('date')));
				 $datas = array(
                             'date'         => $date,
                             'amount'       => $this->input->post('amouns'),
                             'paid_by'      => $this->input->post('paided_by'),
                             'note'         => $this->input->post('noter'),
                             'company_id'   => $this->input->post('customer'),
                             'created_by'   => $this->session->userdata('user_id'),
                             'cash_type'=>'1',
                              'payment_method'    => $this->input->post('payment_methods1'),
                            
            ); //print_r($datas);die();
            

           $cus_id=$this->input->post('customer');
            
            $amnt=$this->input->post('amouns');
            
            $querys=$this->transaction_model->check_totsaleamount($cus_id);
             $amn_sale = $querys[0]->s_grand_total;
               
            $total_amount = $amn_sale ;
            
             if($amnt > $total_amount)
		    {
		    
		      // $this->session->set_flashdata('message', lang("Deposit_amount_exceeded"));
		      $this->session->set_flashdata('error', 'Deposit Amount Exceed');
               admin_redirect("transaction/add");
		    }

             $custdata = array(
                'deposit_amount' => ($company->deposit_amount+$this->input->post('amouns'))
            );   
            



			}
				if($test == 'supplier_deposit')
			{
			$cust=$this->input->post('supplier');
        $company = $this->companies_model->getCompanyByID($cust);
        $date = $this->sma->fld(trim($this->input->post('date')));
				 $datas = array(
                             'date'         => $date,
                             'amount'       => $this->input->post('amounted'),
                             'paid_by'      => $this->input->post('paid_by'),
                             'note'         => $this->input->post('notes'),
                             'company_id'   => $this->input->post('supplier'),
                             'created_by'   => $this->session->userdata('user_id'),
                             'cash_type'=>'3',
                              'payment_method'    => $this->input->post('payment_methods2'),
            );
           
             $cdata = array(
                'deposit_amount' => ($company->deposit_amount+$this->input->post('amounted'))
            );   
            
        
			}
		if($test == 'expense')
			{
				$exp = $this->input->post('cate');
				$typing = $this->db->get_where('accounts',array('id'=>  $exp))->row()->type;
				$acnt_type=$this->input->post('Account');
				$am =$this->input->post('amoun');
				$va = $this->input->post('vat');
				$tot_am = $am + $va;
				$data = array(
								'type' =>$this->input->post('type'),
								'warehouse_id' => $warehouse_id,
								'date' =>$this->sma->fld(trim($this->input->post('dates'))),
								'Account' => $this->input->post('Account') ? $this->input->post('Account') : 0,
								'category' => $this->input->post('cate'),
								'amount' => $tot_am,
								'vat' => $this->input->post('vat'),
								'description' => $this->sma->clear_tags($this->input->post('description')),
								'deposit_withdrawal' => $this->input->post('deposit/withdrawal'),
								'note' => $this->sma->clear_tags($this->input->post('noted')),
								 'acc_type' =>  $typing,
				                 'cash_type'=>'3',
				
							);
							$expense_data =array(
							    'date' =>$this->sma->fld(trim($this->input->post('dates'))),
							    'warehouse_id' => $warehouse_id,
							    'amount' => $tot_am,
							    'note' => $this->sma->clear_tags($this->input->post('noted')),
							    'created_by'=>$this->session->userdata('user_id'),
							    'account' => $acnt_type,
							    'category' => $exp,

							    
							    );
			}
			if($test == 'customer_deposit'){
			if ($this->transaction_model->addCustomer($datas, $custdata )) 
        {
            $this->session->set_flashdata('message', lang("Customer_deposit_added"));
            admin_redirect("customers/index");
        }
        	else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
				$meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
				$this->page_construct('transaction/add', $meta, $this->data);
			}
			
			}
				if($test == 'supplier_deposit'){
			if ($this->transaction_model->addSupplier($datas,$cdata)) 
        {
            $this->session->set_flashdata('message', lang("Supplier_deposit_added"));
            admin_redirect("suppliers/index");
        }
        	else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
				$meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
				$this->page_construct('transaction/add', $meta, $this->data);
			}
			
			}
				if($test == 'expense'){
			// $this->sma->print_arrays($data);
			
			if ($this->transaction_model->addTransa($data)) 
			{
			    $this->transaction_model->addExpenseTransaction($expense_data);
				$this->session->set_flashdata('message', lang("transaction_added"));
				admin_redirect('transaction/listTR');
			} 
				else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
				$meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
				$this->page_construct('transaction/listTR', $meta, $this->data);
			}
			
				}
				if($test == 'income'){
			
			if ($this->transaction_model->addTransa($data)) 
			{
				$this->session->set_flashdata('message', lang("transaction_added"));
				admin_redirect('transaction/listTR');
			} 
				else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));

				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
				$meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
				$this->page_construct('transaction/listTR', $meta, $this->data);
			}
			
				}
		
		}
		else
		{
			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
			$this->data['account'] = $this->transaction_model->getAllAccount();
			$this->data['categories'] = $this->site->getAllCate();
			$this->data['transaction'] = $this->transaction_model->getAllTransaction();  
			$this->data['customerlist'] = $this->transaction_model->getCompanyByID();
			$this->data['warehouses'] = $this->site->getAllWarehouses();
			 $this->data['suppllist'] = $this->transaction_model->getCompaniesByID();
			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/add'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transaction')));
			$meta = array('page_title' => lang('add_transaction'), 'bc' => $bc);
			$this->page_construct('transaction/add', $meta, $this->data);
		}
	}	
	function transaction_view($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		if ($this->input->post('id')) 
		{
            $id = $this->input->post('id');
        }
		$this->data['product'] = $this->transaction_model->getAllTransactionByID($id);
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('transaction_view')));
        $meta = array('page_title' => lang('transaction_view'), 'bc' => $bc);
        $this->page_construct('transaction/transaction_view', $meta, $this->data);
    }
	
	function deleteS($id)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->input->get('id')) 
		{
            $id = $this->input->get('id');
        }

        if ($this->transaction_model->deleteTransaction($id)) 
		{
            if($this->input->is_ajax_request()) 
			{
                $this->sma->send_json(array('error' => 0, 'msg' => lang("transaction_deleted")));
            }
            $this->session->set_flashdata('message', lang('transaction_deleted'));
            admin_redirect('transaction/listTR');
        }

    }
	
	function transaction_viewe($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		if ($this->input->post('id')) 
		{
            $id = $this->input->post('id');
        }
		$this->data['product'] = $this->transaction_model->getAllTransactionByID($id);
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listExpense'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('transaction_view')));
        $meta = array('page_title' => lang('transaction_view'), 'bc' => $bc);
        $this->page_construct('transaction/transaction_view', $meta, $this->data);
    }
	
	function deleteSe($id)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->input->get('id'))
		{
            $id = $this->input->get('id');
        }

        if ($this->transaction_model->deleteTransaction($id)) 
		{
            if($this->input->is_ajax_request()) 
			{
                $this->sma->send_json(array('error' => 0, 'msg' => lang("transaction_deleted")));
            }
            $this->session->set_flashdata('message', lang('transaction_deleted'));
            admin_redirect('transaction/listExpense');
        }

    }
	
	function transaction_viewi($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		if ($this->input->post('id')) 
		{
            $id = $this->input->post('id');
        }
		$this->data['product'] = $this->transaction_model->getAllTransactionByID($id);
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listIncome'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('transaction_view')));
        $meta = array('page_title' => lang('transaction_view'), 'bc' => $bc);
        $this->page_construct('transaction/transaction_view', $meta, $this->data);
    }
	
	function deleteSi($id)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->input->get('id')) 
		{
            $id = $this->input->get('id');
        }

        if ($this->transaction_model->deleteTransaction($id)) 
		{
            if($this->input->is_ajax_request()) 
			{
                $this->sma->send_json(array('error' => 0, 'msg' => lang("transaction_deleted")));
            }
            $this->session->set_flashdata('message', lang('transaction_deleted'));
            admin_redirect('transaction/listIncome');
        }

    }
     function sales()
    {
         $this->data['warehouses'] = $this->site->getAllWarehouses();
      $warehouse = $this->input->post('warehouse') ? $this->input->post('warehouse') : NULL;
       $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
      /* if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }*/
         $this->data['transaction'] = $this->transaction_model->getAllTransactions($warehouse,$start_date, $end_date);
        
      	$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('tr_list')));
        $meta = array('page_title' => lang('tr_list'), 'bc' => $bc);
        $this->page_construct('transaction/listTR', $meta, $this->data);
    }
	  function in_sales()
    {
         $this->data['warehouses'] = $this->site->getAllWarehouses();
      $warehouse = $this->input->post('warehouse') ? $this->input->post('warehouse') : NULL;
       $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
      /* if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }*/
         $this->data['transaction'] = $this->transaction_model->getAllTransactions($warehouse,$start_date, $end_date);
      //  print_r($this->data['transaction']);die();
      $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listIncome'), 'page' => lang('list')), array('link' => '#', 'page' => lang('in_list')));
        $meta = array('page_title' => lang('in_list'), 'bc' => $bc);
        $this->page_construct('transaction/listIncome', $meta, $this->data);
    }
      function ex_sales()
    {
         $this->data['warehouses'] = $this->site->getAllWarehouses();
      $warehouse = $this->input->post('warehouse') ? $this->input->post('warehouse') : NULL;
       $start_date = $this->input->post('start_date') ? $this->input->post('start_date') : NULL;
        $end_date = $this->input->post('end_date') ? $this->input->post('end_date') : NULL;
      /* if ($start_date) {
            $start_date = $this->sma->fld($start_date);
            $end_date = $this->sma->fld($end_date);
        }*/
         $this->data['transaction'] = $this->transaction_model->getAllTransactions($warehouse,$start_date, $end_date);
        
      		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listExpense'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('ex_list')));
        $meta = array('page_title' => lang('ex_list'), 'bc' => $bc);
        $this->page_construct('transaction/listExpense', $meta, $this->data);
    }
	
	
	function listTR()
    {
        $this->data['warehouses'] = $this->site->getAllWarehouses();
        $this->data['transaction'] = $this->transaction_model->getAllTransaction();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('tr_list')));
        $meta = array('page_title' => lang('tr_list'), 'bc' => $bc);
        $this->page_construct('transaction/listTR', $meta, $this->data);
    }
	
	function listExpense()
    {
          $this->data['warehouses'] = $this->site->getAllWarehouses();
        $this->data['transaction'] = $this->transaction_model->getAllTransaction();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listExpense'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('ex_list')));
        $meta = array('page_title' => lang('ex_list'), 'bc' => $bc);
        $this->page_construct('transaction/listExpense', $meta, $this->data);
    }
	
	function listIncome()
    {
          $this->data['warehouses'] = $this->site->getAllWarehouses();
        $this->data['transaction'] = $this->transaction_model->getAllTransaction();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listIncome'), 'page' => lang('list')), array('link' => '#', 'page' => lang('in_list')));
        $meta = array('page_title' => lang('in_list'), 'bc' => $bc);
        $this->page_construct('transaction/listIncome', $meta, $this->data);
    }
	
	function add_transfer()
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$this->data['account'] = $this->transaction_model->getAllAccount();
		$this->data['accounting'] = $this->transaction_model->getAllAccount();
        $this->data['transaction'] = $this->transaction_model->getAllTransaction();   
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/add_transfer'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('add_transfer')));
        $meta = array('page_title' => lang('add_transfer'), 'bc' => $bc);
        $this->page_construct('transaction/add_transfer', $meta, $this->data);
		
    }
	function save_transfer()
    {
    	$this->sma->checkPermissions();
        $this->load->helper('security');
		$accno =  $this->input->post('from_account') ? $this->input->post('from_account') : 0;
		$type = $this->input->post('to_account');
		$amount = $this->input->post('Amount');
		$accounts = $this->transaction_model->getAllAccount();
		$value = substr(md5(rand(100000000, 20000000000)), 0, 7); 
		$values = substr(md5(rand(100000000, 20000000000)), 0, 7); 
		if($accounts)
		{
			foreach($accounts as $rows)
			{
				$acc = $rows->Account_No;
				if($acc == $accno)
				{
					$id = $rows->id;
					$dat = $rows->date;
					$name = $rows->Name;
					$ty = $rows->type;
					$note = $rows->Note;
					$balance = $rows->Intial_Balance;
					$bal = $balance - $amount;
				}
				if($acc == $type)
				{
					$ids = $rows->id;
					$datw = $rows->date;
					$names = $rows->Name;
					$tys = $rows->type;
					$notes = $rows->Note;
					$balan = $rows->Intial_Balance;
					$balce = $balan + $amount;
				}
			}
			$data = array(
							'date' =>$dat,
							'Account_No' => $accno,
							'Name' => $name,
							'type' =>$ty,
							'Intial_Balance' => $bal,
							'Note' => $note,
						);
			$datas = array(
							'date' =>$datw,
							'Account_No' => $type,
							'Name' => $names,
							'type' =>$tys,
							'Intial_Balance' => $balce,
							'Note' => $notes,
						);
			$datads = array(
									'type' =>'expense',
									'date' =>date("Y-m-d H:i:s"),
									'Account' => $accno,
									'category' => 'transfer',
									'amount' => $amount,
									'payment_method' => 'cash',
									'reference_no' => $values,
									'description' => $note,
						    );
			$datad = array(
									'type' =>'income',
									'date' =>date("Y-m-d H:i:s"),
									'Account' => $type,
									'category' => 'transfer',
									'amount' => $amount,
									'payment_method' => 'cash',
									'reference_no' => $value,
									'description' => $notes,
						   );
			if (($this->transaction_model->updateAccount($ids,$datas)) && ($this->transaction_model->updateAccount($id,$data))&& ($this->transaction_model->addTransaction($datads))&& ($this->transaction_model->addTransaction($datad)) )
			{
				$this->session->set_flashdata('message', lang("Account_updated"));
				admin_redirect('transaction/listTR_account');
			} 
			else 
				{
					$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
					$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('edit_account')));
					$meta = array('page_title' => lang('add_Account'), 'bc' => $bc);
					$this->page_construct('transaction/listTR_account', $meta, $this->data);
				}
		}
		
		
    }
		
	
	
	
/*************************************** Account********************************************/
	
	function account()
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$this->data['type'] = $this->site->getAllType();
		$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('add_Account')));
        $meta = array('page_title' => lang('add_Account'), 'bc' => $bc);
        $this->page_construct('transaction/account', $meta, $this->data);
		
    }
	function save_account()
    {
    	
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$type =$this->input->post('type');
		$this->form_validation->set_rules('type', 'type', 'required');
		if ($this->form_validation->run() == true) 
		{
			$data = array(
							
							'Name' => $this->input->post('Name') ? $this->input->post('Name') : 0,
							'type' =>$this->input->post('type'),
							'belongs_to' =>$this->input->post('belongs_to'),
							'account_category' => $this->input->post('account_category'),
						);
			if ($this->transaction_model->addAccount($data)) 
			{
				$this->session->set_flashdata('message', lang("Account_added"));
				admin_redirect('transaction/listTR_account');
			} 
			else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
				$this->data['categories'] = $this->site->getAllCategories();
				$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('add_Account')));
				$meta = array('page_title' => lang('add_Account'), 'bc' => $bc);
				$this->page_construct('transaction/listTR_account', $meta, $this->data);
			}
		}
		else
		{
			$this->data['type'] = $this->site->getAllType();
			$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('add_Account')));
			$meta = array('page_title' => lang('add_Account'), 'bc' => $bc);
			$this->page_construct('transaction/account', $meta, $this->data);
		}
			
	}	
	
	function listTR_account()
    {
        $this->data['account'] = $this->transaction_model->getAllAccount();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('list_Account')));
        $meta = array('page_title' => lang('list_Account'), 'bc' => $bc);
        $this->page_construct('transaction/listTR_account', $meta, $this->data);
    }
	
	function edit_account($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
       
		if ($this->input->post('id')) 
		{
            $id = $this->input->post('id');
        }
       	$this->data['type'] = $this->site->getAllType();
		$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
		$this->data['product'] = $this->transaction_model->getAllAccountByID($id);
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('edit_account')));
        $meta = array('page_title' => lang('edit_account'), 'bc' => $bc);
        $this->page_construct('transaction/edit_account', $meta, $this->data);
		
    }
	
	function view_account($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		if ($this->input->post('id')) 
		{
            $id = $this->input->post('id');
        }
		$this->data['product'] = $this->transaction_model->getAllAccountByID($id);
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('view_account')));
        $meta = array('page_title' => lang('view_account'), 'bc' => $bc);
        $this->page_construct('transaction/view_account', $meta, $this->data);
		
    }
	
	function edit($id)
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
        $this->form_validation->set_rules('type', 'type', 'required');
		if ($this->input->post('id')) 
		{
          $id = $this->input->post('id');
        }
		if ($this->form_validation->run() == true) 
		{
			$data = array(
						
						
						'Name' => $this->input->post('Name') ? $this->input->post('Name') : 0,
						'type' =>$this->input->post('type'),
						'belongs_to' =>$this->input->post('belongs_to'),
						'account_category' => $this->input->post('account_category'),
					 );
			if ($this->transaction_model->updateAccount($id,$data)) 
			{
				$this->session->set_flashdata('message', lang("Account_updated"));
				admin_redirect('transaction/listTR_account');
			} 
			else 
			{
				$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
				$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('edit_account')));
				$meta = array('page_title' => lang('add_Account'), 'bc' => $bc);
				$this->page_construct('transaction/listTR_account', $meta, $this->data);
			}
		}
		else
		{
			$this->data['product'] = $this->transaction_model->getAllAccountByID($id);
			$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/listTR_account'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('edit_account')));
			$meta = array('page_title' => lang('edit_account'), 'bc' => $bc);
			$this->page_construct('transaction/edit_account', $meta, $this->data);							
		}
				
			
    }
	
	function delete($id)
    {
        $this->sma->checkPermissions(NULL, TRUE);

        if ($this->input->get('id')) 
		{
            $id = $this->input->get('id');
        }

        if ($this->transaction_model->deleteAccount($id)) 
		{
            if($this->input->is_ajax_request()) 
			{
                $this->sma->send_json(array('error' => 0, 'msg' => lang("Account_deleted")));
            }
            $this->session->set_flashdata('message', lang('Account_deleted'));
            admin_redirect('transaction/listTR_account');
        }

    }
	/*************************type*********************************/
	
	 function type()
    {
		
		$this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
		$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('type')));
        $meta = array('page_title' => lang('type'), 'bc' => $bc);
        $this->page_construct('transaction/type', $meta, $this->data);
    }

    function getype()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select($this->db->dbprefix('type') . ".id as id,{$this->db->dbprefix('type')}.name as type,{$this->db->dbprefix('account_category')}.name as account_category")
            ->from("type")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('transaction/edit_type/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_type") . "'><i class=\"fa fa-edit\"></i></a> </div>", "id");
			
		$this->datatables->join('account_category', 'type.account_category=account_category.id', 'left');
        echo $this->datatables->generate();
    }

    function add_type()
    {

        $this->form_validation->set_rules('name', lang("type_name"), 'trim|required|is_unique[type.name]');
        
        if ($this->form_validation->run() == true) 
		{

            $data = array(
                'name' => $this->input->post('name'),
               'account_category' => $this->input->post('account_category'),
                );
			
            

        } elseif ($this->input->post('add_type')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/type");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->addType($data)) 
		{
            $this->session->set_flashdata('message', lang("type_added"));
            admin_redirect("transaction/type");
        }
		else 
		{

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
			$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'transaction/add_type', $this->data);

        }
    }

    function edit_type($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("name"), 'required');
        $type_details = $this->site->getTypeByID($id);
        if ($this->input->post('name') != $type_details->name) 
		{
            $this->form_validation->set_rules('name', lang("type_name"), 'required');
        }
        
        if ($this->form_validation->run() == true) 
		{

            $data = array(
                'name' => $this->input->post('name'),
                'account_category' => $this->input->post('account_category'),
                );

            

        } elseif ($this->input->post('edit_type')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/type");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->updateType($id, $data))
		{
            $this->session->set_flashdata('message', lang("type_updated"));
            admin_redirect("transaction/type");
        } else
		{

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
			$this->data['account_category'] = $this->transaction_model->getAllAccountCategory();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['type'] = $type_details;
            $this->load->view($this->theme . 'transaction/edit_type', $this->data);

        }
    }

    function delete_type($id = NULL)
    {

        if ($this->transaction_model->typeHasTransaction($id)) 
		{
            $this->sma->send_json(array('error' => 1, 'msg' => lang("types_has_Transaction")));
        }

        if ($this->transaction_model->deleteType($id)) 
		{
            $this->sma->send_json(array('error' => 0, 'msg' => lang("types_deleted")));
        }
    }
	
	function type_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) 
		{

            if (!empty($_POST['val'])) 
			{
                if ($this->input->post('form_action') == 'delete') 
				{
                    foreach ($_POST['val'] as $id)
					{
                        $this->transaction_model->deleteType($id);
                    }
                    $this->session->set_flashdata('message', lang("Type_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') 
				{

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('Types'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('name'));
                   

                    $row = 2;
                    foreach ($_POST['val'] as $id) 
					{
                        $brand = $this->site->getTypeByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $type->name);
                        
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'Types_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } 
			else 
			{
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } 
		else 
		{
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }
	
	/*************************Category*********************************/
	
	function account_category()
    {
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('account_category')));
        $meta = array('page_title' => lang('account_category'), 'bc' => $bc);
        $this->page_construct('transaction/account_category', $meta, $this->data);
    }

    function getAccountCategory()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name")
            ->from("account_category")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('transaction/edit_account_category/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_account_category") . "'><i class=\"fa fa-edit\"></i></a> </div>", "id");

        echo $this->datatables->generate();
    }

    function add_account_category()
    {

        $this->form_validation->set_rules('name', lang("account_category_name"), 'trim|required|is_unique[account_category.name]|alpha_numeric_spaces');
        
        if ($this->form_validation->run() == true) 
		{

            $data = array(
						'name' => $this->input->post('name'),
               
						);
			
            

        } 
		elseif ($this->input->post('add_account_category')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/account_category");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->addAccountCategory($data)) 
		{
            $this->session->set_flashdata('message', lang("Account_Category_added"));
            admin_redirect("transaction/account_category");
        } 
		else 
		{

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'transaction/add_account_category', $this->data);

        }
    }

    function edit_account_category($id = NULL)
    {

        $this->form_validation->set_rules('name', lang("account_category_name"), 'trim|required|alpha_numeric_spaces');
        $type_details = $this->site->getAccountCategoryByID($id);
        if ($this->input->post('name') != $type_details->name) 
		{
            $this->form_validation->set_rules('name', lang("account_category_name"), 'required|is_unique[account_category.name]');
        }
        
        if ($this->form_validation->run() == true) 
		{

            $data = array(
							'name' => $this->input->post('name'),
               
						);
		} 
		elseif ($this->input->post('edit_account_category')) 
		{
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/account_category");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->updateAccountCategory($id, $data)) 
		{
            $this->session->set_flashdata('message', lang("account_category_updated"));
            admin_redirect("transaction/account_category");
        } 
		else 
		{

            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->data['type'] = $type_details;
            $this->load->view($this->theme . 'transaction/edit_account_category', $this->data);

        }
    }

    function delete_account_category($id = NULL)
    {

        if ($this->settings_model->AccountCategoryHasTransaction($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("type_has_Transaction")));
        }

        if ($this->settings_model->deleteAccountCategory($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("type_deleted")));
        }
    }
	
	function account_category_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) 
		{

            if (!empty($_POST['val'])) 
			{
                if ($this->input->post('form_action') == 'delete') 
				{
                    foreach ($_POST['val'] as $id) 
					{
                        $this->transaction_model->deleteAccountCategory($id);
                    }
                    $this->session->set_flashdata('message', lang("account_category_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') 
				{

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('Account_Category'));
                    $this->excel->getActiveSheet()->SetCellValue('A1', lang('name'));
                   

                    $row = 2;
                    foreach ($_POST['val'] as $id) 
					{
                        $brand = $this->site->getAccountCategoryByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $type->name);
                        
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'Types_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } 
			else 
			{
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } 
		else 
		{
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }
	
/************************************** Account statement******************************/
	
	function statement()
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
		$this->data['account'] = $this->transaction_model->getAllAccount();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/statement'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('Account_Statement')));
        $meta = array('page_title' => lang('Account_Statement'), 'bc' => $bc);
        $this->page_construct('transaction/statement', $meta, $this->data);
		
    }
	
	function save_account_statement()
    {
        $this->sma->checkPermissions();
        $this->load->helper('security');
        $this->form_validation->set_rules('Account', 'Account', 'required');
        if ($this->form_validation->run() == true) 
		{
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$Account = $this->input->post('Account');
			if ($start_date) 
			{
				$start_date = $this->sma->fld($start_date);
				$end_date = $this->sma->fld($end_date);
			}
			$account = $this->transaction_model->addStatement($start_date,$end_date,$Account);
			$this->data['account'] = $account;
			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/statement'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('Account_Statement')));
			$meta = array('page_title' => lang('Account_Statement'), 'bc' => $bc);
			$this->page_construct('transaction/account_statement', $meta, $this->data);
		
		}
		else
		{
			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
			$this->data['account'] = $this->transaction_model->getAllAccount();
			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction/statement'), 'page' => lang('Account')), array('link' => '#', 'page' => lang('Account_Statement')));
			$meta = array('page_title' => lang('Account_Statement'), 'bc' => $bc);
			$this->page_construct('transaction/statement', $meta, $this->data);
		}
	
	}
	
	
	/****************************Transaction Category*******************/
	
	 function transaction_category()
    {
		
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => admin_url('transaction'), 'page' => lang('transaction')), array('link' => '#', 'page' => lang('transaction_category')));
        $meta = array('page_title' => lang('categories'), 'bc' => $bc);
        $this->page_construct('transaction/transaction_category', $meta, $this->data);
    }

    function getTransCategories()
    {

        $this->load->library('datatables');
        $this->datatables
            ->select("id, name")
            ->from("transaction_categories")
            ->add_column("Actions", "<div class=\"text-center\"><a href='" . admin_url('transaction/edit_transaction_category/$1') . "' data-toggle='modal' data-target='#myModal' class='tip' title='" . lang("edit_transaction_category") . "'><i class=\"fa fa-edit\"></i></a></div>", "id");

        echo $this->datatables->generate();
    }

    function add_transaction_category()
    {

       
        $this->form_validation->set_rules('name', lang("name"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {

            $data = array(
                'name' => $this->input->post('name'),
                
            );

        } elseif ($this->input->post('add_transaction_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/transaction_category");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->addTransactionCategory($data)) {
            $this->session->set_flashdata('message', lang("transaction_category_added"));
            admin_redirect("transaction/transaction_category");
        } else {
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'transaction/add_transaction_category', $this->data);
        }
    }

    function edit_transaction_category($id = NULL)
    {
        
        $category = $this->transaction_model->getTransactionCategoryByID($id);
        
        $this->form_validation->set_rules('name', lang("category_name"), 'required|min_length[3]');

        if ($this->form_validation->run() == true) {

            $data = array(
                
                'name' => $this->input->post('name')
            );

        } elseif ($this->input->post('edit_transaction_category')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect("transaction/transaction_categories");
        }

        if ($this->form_validation->run() == true && $this->transaction_model->updateTransactionCategory($id, $data)) {
            $this->session->set_flashdata('message', lang("transaction_category_updated"));
            admin_redirect("transaction/transaction_category");
        } else {
            $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->data['category'] = $category;
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'transaction/edit_transaction_category', $this->data);
        }
    }

    function delete_transaction_category($id = NULL)
    {

        if ($this->transaction_model->hasTransactionCategoryRecord($id)) {
            $this->sma->send_json(array('error' => 1, 'msg' => lang("category_has_transaction")));
        }

        if ($this->transaction_model->deleteTransactionCategory($id)) {
            $this->sma->send_json(array('error' => 0, 'msg' => lang("transaction_category_deleted")));
        }
    }

    function transaction_category_actions()
    {

        $this->form_validation->set_rules('form_action', lang("form_action"), 'required');

        if ($this->form_validation->run() == true) {

            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    foreach ($_POST['val'] as $id) {
                        $this->transaction_model->deleteCategory($id);
                    }
                    $this->session->set_flashdata('message', lang("categories_deleted"));
                    redirect($_SERVER["HTTP_REFERER"]);
                }

                if ($this->input->post('form_action') == 'export_excel') {

                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('categories'));
                    $this->excel->getActiveSheet()->SetCellValue('B1', lang('name'));

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $sc = $this->transaction_model->getCategoryByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $sc->name);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
                    $filename = 'transaction_categories_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', lang("no_record_selected"));
                redirect($_SERVER["HTTP_REFERER"]);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    
}
	

