<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Proxy\V1\Service\Session;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ParticipantOptions {
    /**
     * @param string $participantType The participant_type
     * @param string $identifier The identifier
     * @return ReadParticipantOptions Options builder
     */
    public static function read($participantType = Values::NONE, $identifier = Values::NONE) {
        return new ReadParticipantOptions($participantType, $identifier);
    }

    /**
     * @param string $friendlyName A human readable description of this resource.
     * @param string $participantType The Participant Type of this Participant
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     * @return CreateParticipantOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $participantType = Values::NONE, $proxyIdentifier = Values::NONE, $proxyIdentifierSid = Values::NONE) {
        return new CreateParticipantOptions($friendlyName, $participantType, $proxyIdentifier, $proxyIdentifierSid);
    }

    /**
     * @param string $participantType The Participant Type of this Participant
     * @param string $identifier The phone number of this Participant.
     * @param string $friendlyName A human readable description of this resource.
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     * @return UpdateParticipantOptions Options builder
     */
    public static function update($participantType = Values::NONE, $identifier = Values::NONE, $friendlyName = Values::NONE, $proxyIdentifier = Values::NONE, $proxyIdentifierSid = Values::NONE) {
        return new UpdateParticipantOptions($participantType, $identifier, $friendlyName, $proxyIdentifier, $proxyIdentifierSid);
    }
}

class ReadParticipantOptions extends Options {
    /**
     * @param string $participantType The participant_type
     * @param string $identifier The identifier
     */
    public function __construct($participantType = Values::NONE, $identifier = Values::NONE) {
        $this->options['participantType'] = $participantType;
        $this->options['identifier'] = $identifier;
    }

    /**
     * The participant_type
     * 
     * @param string $participantType The participant_type
     * @return $this Fluent Builder
     */
    public function setParticipantType($participantType) {
        $this->options['participantType'] = $participantType;
        return $this;
    }

    /**
     * The identifier
     * 
     * @param string $identifier The identifier
     * @return $this Fluent Builder
     */
    public function setIdentifier($identifier) {
        $this->options['identifier'] = $identifier;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Proxy.V1.ReadParticipantOptions ' . implode(' ', $options) . ']';
    }
}

class CreateParticipantOptions extends Options {
    /**
     * @param string $friendlyName A human readable description of this resource.
     * @param string $participantType The Participant Type of this Participant
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     */
    public function __construct($friendlyName = Values::NONE, $participantType = Values::NONE, $proxyIdentifier = Values::NONE, $proxyIdentifierSid = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['participantType'] = $participantType;
        $this->options['proxyIdentifier'] = $proxyIdentifier;
        $this->options['proxyIdentifierSid'] = $proxyIdentifierSid;
    }

    /**
     * A human readable description of this resource, up to 64 characters.
     * 
     * @param string $friendlyName A human readable description of this resource.
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The Participant Type of this Participant. One of `message-only`, `voice-only` or `voice-and-message`.
     * 
     * @param string $participantType The Participant Type of this Participant
     * @return $this Fluent Builder
     */
    public function setParticipantType($participantType) {
        $this->options['participantType'] = $participantType;
        return $this;
    }

    /**
     * The proxy phone number for this Participant.
     * 
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @return $this Fluent Builder
     */
    public function setProxyIdentifier($proxyIdentifier) {
        $this->options['proxyIdentifier'] = $proxyIdentifier;
        return $this;
    }

    /**
     * The unique SID identifier of the Proxy Identifier.
     * 
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     * @return $this Fluent Builder
     */
    public function setProxyIdentifierSid($proxyIdentifierSid) {
        $this->options['proxyIdentifierSid'] = $proxyIdentifierSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Proxy.V1.CreateParticipantOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateParticipantOptions extends Options {
    /**
     * @param string $participantType The Participant Type of this Participant
     * @param string $identifier The phone number of this Participant.
     * @param string $friendlyName A human readable description of this resource.
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     */
    public function __construct($participantType = Values::NONE, $identifier = Values::NONE, $friendlyName = Values::NONE, $proxyIdentifier = Values::NONE, $proxyIdentifierSid = Values::NONE) {
        $this->options['participantType'] = $participantType;
        $this->options['identifier'] = $identifier;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['proxyIdentifier'] = $proxyIdentifier;
        $this->options['proxyIdentifierSid'] = $proxyIdentifierSid;
    }

    /**
     * The Participant Type of this Participant. One of `message-only`, `voice-only` or `voice-and-message`.
     * 
     * @param string $participantType The Participant Type of this Participant
     * @return $this Fluent Builder
     */
    public function setParticipantType($participantType) {
        $this->options['participantType'] = $participantType;
        return $this;
    }

    /**
     * The phone number of this Participant.
     * 
     * @param string $identifier The phone number of this Participant.
     * @return $this Fluent Builder
     */
    public function setIdentifier($identifier) {
        $this->options['identifier'] = $identifier;
        return $this;
    }

    /**
     * A human readable description of this resource, up to 64 characters.
     * 
     * @param string $friendlyName A human readable description of this resource.
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The proxy phone number for this Participant.
     * 
     * @param string $proxyIdentifier The proxy phone number for this Participant.
     * @return $this Fluent Builder
     */
    public function setProxyIdentifier($proxyIdentifier) {
        $this->options['proxyIdentifier'] = $proxyIdentifier;
        return $this;
    }

    /**
     * The unique SID identifier of the Proxy Identifier.
     * 
     * @param string $proxyIdentifierSid Proxy Identifier Sid.
     * @return $this Fluent Builder
     */
    public function setProxyIdentifierSid($proxyIdentifierSid) {
        $this->options['proxyIdentifierSid'] = $proxyIdentifierSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Proxy.V1.UpdateParticipantOptions ' . implode(' ', $options) . ']';
    }
}