<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSubTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('sub_tasks'))
        {
            Schema::create('sub_tasks', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->date('due_date');
                $table->integer('task_id');
                $table->string('user_type');
                $table->integer('created_by');
                $table->integer('status')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sub_tasks');
    }
}
